function [] = propstats(dir_tmp1,dir_tmp2,header)
%function for running stats on the properties collected by join_props.
%Synatax:   [] = propstats();
%Input:     dir_tmp1 = first directory of properties
%           dir_tmp2 = second directory of properties
%           header = a string attached to the front of the output filename,
%               default = 'empty'
%Output:    none
if nargin==0||isempty(dir_tmp1)||isempty(dir_tmp2)
    dir_tmp1 = uigetdir2('','First directory of properties');    %get the directory
    dir_tmp2 = uigetdir3('','second directory of properties');    %get the directory
end
if nargin<3
    header = '';
end
%Now sort through the directory and find the
[filenames1,names1,header1] = dir_sort(dir_tmp1);
[filenames2,names2,header2] = dir_sort(dir_tmp2);

%Now open each file append and save
nameidx = 1;    %initialize
name_tmp = names1(1);
for k = 1:size(filenames1,2)    %first directory
    if ~strcmp(name_tmp,names1(k));     %not equal iterate
        name_tmp = names1(k);
        nameidx = nameidx+1;
    end
    for j = 1:size(filenames2,2) %go through the file sets in the second directory
        if strcmp(names1(k),names2(j))&&strcmp(header1(k),header2(j))    %if there is a match compare
            try     %file could be empty
                prop_data1 = single(dlmread([dir_tmp1,filesep,filenames1{k}],',',1,0));
            catch
                warning([filenames1{k},' is empty']);
            end
            try     %file could be empty
                prop_data2 = single(dlmread([dir_tmp2,filesep,filenames2{j}],',',1,0));
            catch
                warning([filenames1{k},' is empty']);
            end
            %now run stats on the file - add as many blocks of stats as you
            %want
            %first make sure the two arrays are the same size
            %adjust colums
            ptsize1 = size(prop_data1,1);
            ptsize2 = size(prop_data2,1);
            if ptsize1>ptsize2  %pad prop_tmp2
                prop_data2 = vertcat(prop_data2,nan(ptsize1-ptsize2,size(prop_data2,2)));
            elseif ptsize2>ptsize1  %pad prop_tmp1
                prop_data1 = vertcat(prop_data1,nan(ptsize2-ptsize1,size(prop_data1,2)));
            end
            %adjust rows
            ptsize1 = size(prop_data1,2);
            ptsize2 = size(prop_data2,2);
            if ptsize1>ptsize2  %pad prop_tmp2
                prop_data2 = horzcat(prop_data2,nan(size(prop_data2,1),ptsize1-ptsize2));
            elseif ptsize2>ptsize1  %pad prop_tmp1
                prop_data1 = horzcat(prop_data1,nan(size(prop_data1,1),ptsize2-ptsize1));
            end
            %block one, kruskalwallis raw
            p(nameidx,str2num(header1{k}),1) = kruskalwallis([prop_data1,prop_data2],[],'off');
            %block two, kruskalwallis, joined raw
            prop_joined1 = [];    %initiate
            prop_joined2 = [];
            for i = 1:size(prop_data1,2)     %go through each column & join
                prop_joined1 = vertcat(prop_joined1,prop_data1(:,i));
            end
            for i = 1:size(prop_data2,2)     %go through each column & join
                prop_joined2 = vertcat(prop_joined2,prop_data2(:,i));
            end
            p(nameidx,str2num(header1{k}),2) = kruskalwallis([prop_joined1,prop_joined2],[],'off');
            %block three, kruskalwallis, median normalized
%             norm1 = nanmedian(prop_data1,1);     %find the median
%             norm2 = nanmedian(prop_data2,1);
%             prop_data1 = prop_data1./repmat(norm1,size(prop_data1,1),1);   %normalize
%             prop_data2 = prop_data2./repmat(norm2,size(prop_data2,1),1);
            prop_tmp1 = manorm(prop_data1,'Method','median','LogData',1);
            prop_tmp2 = manorm(prop_data2,'Method','median','LogData',1);
            p(nameidx,str2num(header1{k}),3) = kruskalwallis([prop_tmp1,prop_tmp2],[],'off');
            %block four, kruskalwallis, std normalized
            prop_tmp1 = manorm(prop_data1,'Method','std');
            prop_tmp2 = manorm(prop_data2,'Method','std');
            p(nameidx,str2num(header1{k}),4) = kruskalwallis([prop_tmp1,prop_tmp2],[],'off');
            %block five, kruskalwallis, mad normalized
            prop_tmp1 = manorm(prop_data1,'Method','mad','LogData',1);
            prop_tmp2 = manorm(prop_data2,'Method','mad','LogData',1);
            p(nameidx,str2num(header1{k}),5) = kruskalwallis([prop_tmp1,prop_tmp2],[],'off');
            %block six, kruskalwallis, quantile normalized
            prop_tmp1 = quantilenormloco(prop_data1);
            prop_tmp2 = quantilenormloco(prop_data2);
            p(nameidx,str2num(header1{k}),6) = kruskalwallis([prop_tmp1,prop_tmp2],[],'off');
            %block seven, average
            p(nameidx,str2num(header1{k}),7) = nanmean(nanmean(prop_data1));     %average prop value 1
            p(nameidx,str2num(header1{k}),8) = nanmean(nanmean(prop_data2));     %average prop value 2
            %block eight, median
            p(nameidx,str2num(header1{k}),9) = nanmean(nanmedian(prop_data1));     %median prop value 1
            p(nameidx,str2num(header1{k}),10) = nanmean(nanmedian(prop_data2));     %median prop value 2
            %block nine, stdev of median
            p(nameidx,str2num(header1{k}),11) = nanstd(nanmedian(prop_data1));     %std prop value 1
            p(nameidx,str2num(header1{k}),12) = nanstd(nanmedian(prop_data2));     %std prop value 2
        end
    end
end

mkdir(dir_tmp1,'propstats');
if ~isempty(p)   %make sure there is data first
    %now save out the data file
    uq_names = unique(names1);  %create labels
    col_label = {'raw','rawjoined','median_norm','std_norm','mad_norm','quantile_norm','mean1','mean2','med1','med2','std1','std2'};
    for l = 1:size(p,2)     %save each column independently
        data_tmp = reshape(p(:,l,:),size(p,1),size(p,3));
        dataout = dataset({data_tmp,col_label{:}},'obsname',uq_names);
        sav2csv(dataout,[header,num2str(l),'_p-value.csv'],[dir_tmp1,'\propstats']);
    end
end


%-----------------------------------------------------------------------------------------------------------------------------
function [filenames,f_tmp,h_tmp] = dir_sort(dir_tmp)
%give the directory and it will sort out the files in it and put a cell
%array of filenames
dir_struct = dir(dir_tmp);  %grab the directory information
idx = [dir_struct.isdir];   %grab all of the isdir numbers
names = {dir_struct.name};   %grab the all of the names in the root
filenames = names(~idx);
%filename_tmp = filename_tmp(3:end,:);
for i = 1:size(filenames,2)      %step through each filename and pull the wanted word
    filename_tmp = filenames{i};
    strmask = isstrprop(filename_tmp,'punct');  %find the punctuations, we only want the last two
    strmask2 = filename_tmp=='&';       %we are going to exempt the & character
    strmask3 = isstrprop(filename_tmp,'wspace');    %included the spaces as well
    strmask = strmask-strmask2+strmask3;     %removed and append
    [x,y] = find(strmask==1);  %get the positions
    a = 1;  %initiate
    b = 1;
    tmp = filename_tmp(1,y(end-a)+1:y(end-b)-1);    %create an array of the words
    while ~isempty(str2num(tmp))   %not empty = numbers or vertices file, push forward one and go
        a = a+1;
        b = b+1;
        if size(y,2)-a==0
            break
        end
        tmp = filename_tmp(1,y(end-a)+1:y(end-b)-1);    %create an array of the words
    end
    %now do the same for the front
    a = 1;
    tmp = filename_tmp(1,1:y(1+a)-1);
    while ~isempty(str2num(tmp))&&size(y,2)~=a+1   %not empty = numbers or vertices file, push forward one and go
        a = a+1;
        tmp = filename_tmp(1,1:y(1+a)-1);    %create an array of the words
    end
    f_tmp{i,:} = filename_tmp(1,y(a)+1:y(end-b)-1);
    %all we need is the number at the end
    h_tmp{i,:} = filename_tmp(1,y(end)-1);
end
%-----------------------------------------------------------------------------------------------------------------------------
function [norm_data] = quantilenormloco(data)
%This little function makes sure quantile normalization works
%first check to make sure the input data does not have empty columns
data_chk = isnan(data);
chk_data = sum(data_chk,1);     %beging selection process for empty or singleton data columns
chk_data = abs(chk_data-size(data,1));  %nan items calculated
idx = find(chk_data<=1);    %index of the empty or singleton columns
if ~isempty(idx)     %there is an empty or singleton column, fix that
    norm_data = data;     %copy original matrix context for reconstitution
    reconidx = find(chk_data>1);   %index of reconstitution
    data(:,idx) = [];       %remove temporarily
    if ~isempty(data)   %if all is gone, don't do it
        norm_tmp = quantilenorm(data,'Median',1);     %normalize
        norm_data(:,reconidx) = norm_tmp;   %reconstituted in original contex
    end
else    %no problems go on
    norm_data = quantilenorm(data,'Median',1);
end